<?php
/*
	DevSaver Web Framework
	Copyright (c) 2013-2014 DevSaver. 
	All rights reserved.
		web:  www.devsaver.com
		mail: support@devsaver.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CShortcodes extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		$this->name = "shortcodes";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;


		if ($_GET["mod"] == $this->name) {
			$this->tpl_module = $this->module->plugins["modules"]->LoadDefaultModule($this->name);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];

			//$this->__install();

			switch ($sub) {

				case "landing":					
					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);

					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "browser":
					return $this->Browser();
				break;

				case "duplicate":
					return $this->Duplicate();
				break;

			}
		}
	}



	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Browser() {
		global $base;
		
		$tpl = new CTemplateDynamic($this->tpl_path . "codes.htm");

		$items = $this->db->QFetchRowArray("SELECT * FROM {$this->tables['plugin:shortcodes']}");

		if (is_array($items)) {
			foreach ($items as $key => $val) {
				$items[$key]["cnt"] = ++$cnt;

				$tmp = explode("," , $val["shortcode_device"]);
				$data = null;


				if (in_array("1" , $tmp))
					$data[] = '<span class="f16 sign sign-desktop"></span>';

				if (in_array("2" , $tmp))
					$data[] = '<span class="f16 sign sign-tablet"></span>';

				if (in_array("3" , $tmp))
					$data[] = '<span class="f16 sign sign-mobile"></span>';

				
				if (is_Array($data)) {
					$items[$key]["devices"] = implode(", " , $data);
				} else {
					$items[$key]["devices"] = "";
				}
				
				
			}
			
		}

		if (is_array($this->module->plugins)) {
			foreach ($this->module->plugins as $key => $val) {

				if (method_exists($this->module->plugins[$key] , "shortcodesBrowser")) {
					$shortcodes[] = $this->module->plugins[$key]->shortcodesBrowser();												
				}
				
			}			
		}

		$cnt = 1;
		if (is_array($shortcodes)) {
			foreach ($shortcodes as $key => $val) {
				$shortcodes[$key]["code"] = ++$cnt;
			}			
		}

		echo $tpl->blockReplace(
			"Main" , 
			array(
				"manual"	=> $base->html->Table(
					$tpl , 
					"" , 
					$items
				),

				"shortcodes_titles"	=> is_array($shortcodes) ? $base->html->Table(
					$tpl , 
					"Titles",
					$shortcodes
				) : "",

				"shortcodes_content"	=> is_array($shortcodes) ? $base->html->Table(
					$tpl , 
					"Content",
					$shortcodes
				) : ""

			)
		);

		die();
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function Duplicate() {
		$old = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:shortcodes']} WHERE shortcode_id=%d" , array($_GET["shortcode_id"]));

		if (is_array($old)) {
			unset($old["shortcode_id"]);

			$old["shortcode_code"] .="copy";

			$id = $this->db->QueryInsert(
				$this->tables["plugin:shortcodes"],
				$old
			);

			urlredirect("index.php?mod=shortcodes&sub=landing&action=edit&shortcode_id={$id}&returnurl=" . urlencode("index.php?mod=shortcodes&sub=landing"));
		}
		
	}
	
}

?>